from PIL import Image, ImageDraw
import json
import os
from tqdm import tqdm
import random
from datetime import datetime
import time
from openai import OpenAI
import re
import os
import base64
import openai



_PROMPT_OTHER = """You are an AI assistant designed to simulate the model's reasoning process before executing a given action in a gui navigation task.  Given the task instruction, current screenshot, past actions, the previous history summary, and the current action to be executed, generate a rigorous chain of thought. You must strictly follow these reasoning steps:
(1) Progress Estimation: Interface Comprehension and Progress Estimation
(2) Decesion Reasoning: Strategy Formulation
(3) History Summary: Update the history summary according the action you executed

### Output format:
<Progress Estimation>
... (one or two sentence)
</Progress Estimation>
<Decesion Reasoning>
... (one or two sentence)
</Decesion Reasoning>
<History Summary>
... (one or two sentence)
</History Summary>

###Example Input & Output
Input:
Task Instruction: Find all events taking place in New York City during the month of September.
Current Action: {{'action': CLICK, 'value': 'Apply', 'position':[0.3, 0.66]}}
Previous History Summary: The user first changed the location to New York, then set the start date to September 1, and set the end data to September 30.
Output:
<Progress Estimation>
The user has successfully set the location to New York and selected the date range for September 1-30, but the events displayed are still for March, indicating the need to apply the date filter.
</Progress Estimation>
<Decesion Reasoning>
Clicking the 'Apply' button will confirm the selected date range (September 1-30) and refresh the event listings to show only those occurring in New York City during September.
</Decesion Reasoning>
<History Summary>
The user changed the location to New York, set the date range to September 1-30, and applied the filters to update the event listings.
</History Summary>

###Input
Task Instruction: {_TASK}
Current Action: {_ACTION}
Previous History Summary: {_MEMO}
"""


def encode_image(image_path):
    with open(image_path, "rb") as image_file:
        return base64.b64encode(image_file.read()).decode("utf-8")

def get_answer(step):
    action_type_id = step['action_type_id']
    action_type_text = step['action_type_text']

    click_point = None
    type_text = None
    if action_type_id == 4:
        if action_type_text == 'click':
            touch = step['touch']
            lift = step['lift']
            click_point = [(touch[0] + lift[0]) / 2, (touch[1] + lift[1]) / 2]
            click_point = [round(item, 2) for item in click_point]
    elif action_type_id == 3:
        type_text = step['type_text']

    answer = {'action': action_type_text.upper(), 'value': type_text, 'position': click_point}
    return answer


base_url = "Your url"
api_version = "The API version"
ak = "Your API key" 
model_name = "gpt-4o-mini-2024-07-18" # 
max_tokens = 4096  # range: [0, 4096]
client = openai.AzureOpenAI(
    azure_endpoint=base_url,
    api_version=api_version,
    api_key=ak,
)

datas = json.load(open("Your data path", "r"))
imgs_dir = "Your Image path"
save_path = f'Your save path'
answers_file = os.path.expanduser(save_path)
os.makedirs(os.path.dirname(answers_file), exist_ok=True)
ans_file = open(answers_file, "w")

total_step = {}
history = []

for data in tqdm(datas):
    task = data["task"]
    answer = get_answer(data['step'])
    new_history = history[-1] if len(data['step_history']) != 0 else ''
    filename = data["img_url"]
    img_url = os.path.join(imgs_dir, filename) + '.png'

    system_prompt=_PROMPT_OTHER.format(_TASK= task,_ACTION =answer,_MEMO=new_history)

    messages = [
                {
                    "role": "user",
                    "content": [{
                        "type": "text",
                        "text": system_prompt},
                        {
                            "type": "image_url",
                            "image_url": {
                                "url": f"data:image/jpeg;base64,{encode_image(img_url)}"
                            }
                        }
                        ]
                    }
                ]

    while True:
        try:
            response = client.chat.completions.create(
                model=model_name,
                messages=messages,
                top_p=1.0,
                max_tokens=max_tokens,
                extra_headers={"X-TT-LOGID": "${your_logid}"},
            )
            
            response = response.choices[0].message.content
            # print(response)
            match = re.search(r'<History Summary>(.*?)</History Summary>', response.replace('\n', ' '))
            if match:
                history.append(match.group(1))
                total_step[data['id']] = response
                break
            else:
                print('error')

        except Exception as e:
            print(datetime.now(), e.args)
            time.sleep(10)

    ans_file.write(json.dumps((data["id"], response)) + "\n")
    ans_file.flush()
ans_file.close()
